/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.ByteArrayBinaryTag;
import net.kyori.adventure.nbt.ByteBinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.DoubleBinaryTag;
import net.kyori.adventure.nbt.EndBinaryTag;
import net.kyori.adventure.nbt.FloatBinaryTag;
import net.kyori.adventure.nbt.IntArrayBinaryTag;
import net.kyori.adventure.nbt.IntBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.LongArrayBinaryTag;
import net.kyori.adventure.nbt.LongBinaryTag;
import net.kyori.adventure.nbt.ShortBinaryTag;
import net.kyori.adventure.nbt.StringBinaryTag;
import ua.nanit.limbo.protocol.NbtMessage;

public class NbtMessageUtil {
    public static NbtMessage create(String json) {
        BinaryTag compoundBinaryTag = NbtMessageUtil.fromJson(JsonParser.parseString(json));
        return new NbtMessage(json, compoundBinaryTag);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BinaryTag fromJson(JsonElement json) {
        if (json instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)json;
            if (jsonPrimitive.isNumber()) {
                Number number = json.getAsNumber();
                if (number instanceof Byte) {
                    return ByteBinaryTag.byteBinaryTag((Byte)number);
                }
                if (number instanceof Short) {
                    return ShortBinaryTag.shortBinaryTag((Short)number);
                }
                if (number instanceof Integer) {
                    return IntBinaryTag.intBinaryTag((Integer)number);
                }
                if (number instanceof Long) {
                    return LongBinaryTag.longBinaryTag((Long)number);
                }
                if (number instanceof Float) {
                    return FloatBinaryTag.floatBinaryTag(((Float)number).floatValue());
                }
                if (!(number instanceof Double)) throw new IllegalArgumentException("Unknown JSON element: " + String.valueOf(json));
                return DoubleBinaryTag.doubleBinaryTag((Double)number);
            }
            if (jsonPrimitive.isString()) {
                return StringBinaryTag.stringBinaryTag(jsonPrimitive.getAsString());
            }
            if (!jsonPrimitive.isBoolean()) throw new IllegalArgumentException("Unknown JSON primitive: " + String.valueOf(jsonPrimitive));
            return ByteBinaryTag.byteBinaryTag(jsonPrimitive.getAsBoolean() ? (byte)1 : 0);
        }
        if (json instanceof JsonObject) {
            CompoundBinaryTag.Builder builder = CompoundBinaryTag.builder();
            for (Map.Entry<String, JsonElement> property : ((JsonObject)json).entrySet()) {
                builder.put(property.getKey(), NbtMessageUtil.fromJson(property.getValue()));
            }
            return builder.build();
        }
        if (json instanceof JsonArray) {
            void var5_23;
            List<JsonElement> jsonArray = ((JsonArray)json).asList();
            if (jsonArray.isEmpty()) {
                return ListBinaryTag.listBinaryTag(EndBinaryTag.endBinaryTag().type(), Collections.emptyList());
            }
            BinaryTagType<ByteBinaryTag> tagByteType = ByteBinaryTag.ZERO.type();
            BinaryTagType<IntBinaryTag> tagIntType = IntBinaryTag.intBinaryTag(0).type();
            BinaryTagType<LongBinaryTag> tagLongType = LongBinaryTag.longBinaryTag(0L).type();
            BinaryTagType<? extends BinaryTag> listType = NbtMessageUtil.fromJson(jsonArray.get(0)).type();
            if (listType.equals(tagByteType)) {
                byte[] bytes = new byte[jsonArray.size()];
                for (int i = 0; i < bytes.length; ++i) {
                    bytes[i] = (Byte)((JsonPrimitive)jsonArray.get(i)).getAsNumber();
                }
                ByteArrayBinaryTag byteArrayBinaryTag = ByteArrayBinaryTag.byteArrayBinaryTag(bytes);
                return var5_23;
            } else if (listType.equals(tagIntType)) {
                int[] ints = new int[jsonArray.size()];
                for (int i = 0; i < ints.length; ++i) {
                    ints[i] = (Integer)((JsonPrimitive)jsonArray.get(i)).getAsNumber();
                }
                IntArrayBinaryTag intArrayBinaryTag = IntArrayBinaryTag.intArrayBinaryTag(ints);
                return var5_23;
            } else if (listType.equals(tagLongType)) {
                long[] longs = new long[jsonArray.size()];
                for (int i = 0; i < longs.length; ++i) {
                    longs[i] = (Long)((JsonPrimitive)jsonArray.get(i)).getAsNumber();
                }
                LongArrayBinaryTag longArrayBinaryTag = LongArrayBinaryTag.longArrayBinaryTag(longs);
                return var5_23;
            } else {
                ArrayList<BinaryTag> tagItems = new ArrayList<BinaryTag>(jsonArray.size());
                for (JsonElement jsonEl : jsonArray) {
                    BinaryTag subTag = NbtMessageUtil.fromJson(jsonEl);
                    if (subTag.type() != listType) {
                        throw new IllegalArgumentException("Cannot convert mixed JsonArray to Tag");
                    }
                    tagItems.add(subTag);
                }
                ListBinaryTag listBinaryTag = ListBinaryTag.listBinaryTag(listType, tagItems);
            }
            return var5_23;
        }
        if (!(json instanceof JsonNull)) throw new IllegalArgumentException("Unknown JSON element: " + String.valueOf(json));
        return EndBinaryTag.endBinaryTag();
    }
}

