/*
 * Decompiled with CFR 0.152.
 */
package ua.nanit.limbo.world;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import net.kyori.adventure.nbt.TagStringIO;
import ua.nanit.limbo.server.LimboServer;
import ua.nanit.limbo.server.Log;
import ua.nanit.limbo.world.Dimension;

public final class DimensionRegistry {
    private final LimboServer server;
    private Dimension defaultDimension_1_16;
    private Dimension defaultDimension_1_18_2;
    private Dimension dimension_1_20_5;
    private Dimension dimension_1_21;
    private Dimension dimension_1_21_2;
    private Dimension dimension_1_21_4;
    private CompoundBinaryTag codec_1_16;
    private CompoundBinaryTag codec_1_18_2;
    private CompoundBinaryTag codec_1_19;
    private CompoundBinaryTag codec_1_19_1;
    private CompoundBinaryTag codec_1_19_4;
    private CompoundBinaryTag codec_1_20;
    private CompoundBinaryTag codec_1_20_5;
    private CompoundBinaryTag codec_1_21;
    private CompoundBinaryTag codec_1_21_2;
    private CompoundBinaryTag codec_1_21_4;
    private CompoundBinaryTag codec_1_21_5;
    private CompoundBinaryTag oldCodec;
    private CompoundBinaryTag tags_1_20_5;
    private CompoundBinaryTag tags_1_21_5;

    public DimensionRegistry(LimboServer server) {
        this.server = server;
    }

    public CompoundBinaryTag getCodec_1_16() {
        return this.codec_1_16;
    }

    public CompoundBinaryTag getCodec_1_18_2() {
        return this.codec_1_18_2;
    }

    public CompoundBinaryTag getCodec_1_19() {
        return this.codec_1_19;
    }

    public CompoundBinaryTag getCodec_1_19_1() {
        return this.codec_1_19_1;
    }

    public CompoundBinaryTag getCodec_1_19_4() {
        return this.codec_1_19_4;
    }

    public CompoundBinaryTag getCodec_1_20() {
        return this.codec_1_20;
    }

    public CompoundBinaryTag getCodec_1_20_5() {
        return this.codec_1_20_5;
    }

    public CompoundBinaryTag getCodec_1_21() {
        return this.codec_1_21;
    }

    public CompoundBinaryTag getCodec_1_21_2() {
        return this.codec_1_21_2;
    }

    public CompoundBinaryTag getCodec_1_21_4() {
        return this.codec_1_21_4;
    }

    public CompoundBinaryTag getCodec_1_21_5() {
        return this.codec_1_21_5;
    }

    public CompoundBinaryTag getOldCodec() {
        return this.oldCodec;
    }

    public Dimension getDefaultDimension_1_16() {
        return this.defaultDimension_1_16;
    }

    public Dimension getDefaultDimension_1_18_2() {
        return this.defaultDimension_1_18_2;
    }

    public Dimension getDimension_1_20_5() {
        return this.dimension_1_20_5;
    }

    public Dimension getDimension_1_21() {
        return this.dimension_1_21;
    }

    public Dimension getDimension_1_21_2() {
        return this.dimension_1_21_2;
    }

    public Dimension getDimension_1_21_4() {
        return this.dimension_1_21_4;
    }

    public CompoundBinaryTag getTags_1_20_5() {
        return this.tags_1_20_5;
    }

    public CompoundBinaryTag getTags_1_21_5() {
        return this.tags_1_21_5;
    }

    public void load(String def) throws IOException {
        this.oldCodec = this.readSnbtFile("/dimension/codec_old.snbt");
        this.codec_1_16 = this.readSnbtFile("/dimension/codec_1_16.snbt");
        this.codec_1_18_2 = this.readSnbtFile("/dimension/codec_1_18_2.snbt");
        this.codec_1_19 = this.readSnbtFile("/dimension/codec_1_19.snbt");
        this.codec_1_19_1 = this.readSnbtFile("/dimension/codec_1_19_1.snbt");
        this.codec_1_19_4 = this.readSnbtFile("/dimension/codec_1_19_4.snbt");
        this.codec_1_20 = this.readSnbtFile("/dimension/codec_1_20.snbt");
        this.codec_1_20_5 = this.readSnbtFile("/dimension/codec_1_20_5.snbt");
        this.codec_1_21 = this.readSnbtFile("/dimension/codec_1_21.snbt");
        this.codec_1_21_2 = this.readSnbtFile("/dimension/codec_1_21_2.snbt");
        this.codec_1_21_4 = this.readSnbtFile("/dimension/codec_1_21_4.snbt");
        this.codec_1_21_5 = this.readSnbtFile("/dimension/codec_1_21_5.snbt");
        this.tags_1_20_5 = this.readSnbtFile("/dimension/tags_1_20_5.snbt");
        this.tags_1_21_5 = this.readSnbtFile("/dimension/tags_1_21_5.snbt");
        this.defaultDimension_1_16 = this.getDefaultDimension(def, this.codec_1_16);
        this.defaultDimension_1_18_2 = this.getDefaultDimension(def, this.codec_1_18_2);
        this.dimension_1_20_5 = this.getModernDimension(def, this.codec_1_20_5);
        this.dimension_1_21 = this.getModernDimension(def, this.codec_1_21);
        this.dimension_1_21_2 = this.getModernDimension(def, this.codec_1_21_2);
        this.dimension_1_21_4 = this.getModernDimension(def, this.codec_1_21_4);
    }

    private Dimension getDefaultDimension(String def, CompoundBinaryTag tag) {
        ListBinaryTag dimensions = tag.getCompound("minecraft:dimension_type").getList("value");
        switch (def) {
            case "minecraft:overworld": {
                CompoundBinaryTag overWorld = (CompoundBinaryTag)((CompoundBinaryTag)dimensions.get(0)).get("element");
                return new Dimension(0, def, overWorld);
            }
            case "minecraft:the_nether": {
                CompoundBinaryTag theNether = (CompoundBinaryTag)((CompoundBinaryTag)dimensions.get(2)).get("element");
                return new Dimension(-1, def, theNether);
            }
            case "minecraft:the_end": {
                CompoundBinaryTag theEnd = (CompoundBinaryTag)((CompoundBinaryTag)dimensions.get(3)).get("element");
                return new Dimension(1, def, theEnd);
            }
        }
        CompoundBinaryTag theEnd = (CompoundBinaryTag)((CompoundBinaryTag)dimensions.get(3)).get("element");
        Log.warning((Object)"Undefined dimension type: '%s'. Using OVERWORLD as default", def);
        return new Dimension(0, "minecraft:overworld", theEnd);
    }

    private Dimension getModernDimension(String def, CompoundBinaryTag tag) {
        ListBinaryTag dimensions = tag.getCompound("minecraft:dimension_type").getList("value");
        for (int i = 0; i < dimensions.size(); ++i) {
            CompoundBinaryTag dimension = (CompoundBinaryTag)dimensions.get(i);
            String name = dimension.getString("name");
            CompoundBinaryTag world = (CompoundBinaryTag)dimension.get("element");
            if (!name.startsWith(def)) continue;
            return new Dimension(i, name, world);
        }
        CompoundBinaryTag overWorld = (CompoundBinaryTag)((CompoundBinaryTag)dimensions.get(0)).get("element");
        Log.warning((Object)"Undefined dimension type: '%s'. Using OVERWORLD as default", def);
        return new Dimension(0, "minecraft:overworld", overWorld);
    }

    private CompoundBinaryTag readSnbtFile(String resPath) throws IOException {
        InputStream in = this.server.getClass().getResourceAsStream(resPath);
        if (in == null) {
            throw new FileNotFoundException("Cannot find snbt file " + resPath);
        }
        return TagStringIO.get().asCompound(this.streamToString(in));
    }

    private String streamToString(InputStream in) throws IOException {
        try (BufferedReader bufReader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String string = bufReader.lines().collect(Collectors.joining("\n"));
            return string;
        }
    }
}

